unit IWCompLabel;
{PUBDIST}

interface

uses
  {$IFDEF VSNET}
  System.ComponentModel, System.Drawing,
  {$ELSE}
  {$IFDEF Linux}QControls, {$ELSE}Controls, {$ENDIF}
  {$ENDIF}
  {$IFDEF Linux}QGraphics, {$ELSE}Graphics, {$ENDIF}
  Classes,
  IWControl, IWHTMLTag, IWColor, IWRenderContext;

type
  TIWCustomLabel = class(TIWCustomControl)
  protected
    FAlignment: TAlignment;
    FRawText: Boolean;
    FNoWrap: Boolean;
    FConvertSpaces: Boolean;
    //

    {$IFDEF VSNET}
    function getText: string; reintroduce;virtual;
    procedure setText(AValue: string); reintroduce;virtual;
    {$ENDIF}
    procedure SetAutoSize(Value: Boolean); override;
    procedure SetAlignment(const Value: TAlignment);
    procedure SetRawText(Value: Boolean);
    procedure InitControl; override;
    procedure SetBGColor(Value: TIWColor);
    function GetBGColor : TIWColor;
    function get_HasTabOrder: boolean;override;
  public
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
    function RenderStyle(AComponentContext: TIWBaseHTMLComponentContext): string; override;

    property AutoSize;
    property RawText: Boolean read FRawText write SetRawText;
    {$IFNDEF CLR}
    property WebFont;
    {$ENDIF}
    {$IFDEF VSNET}
    property Text: string read getText write setText;
    {$ENDIF}
  published
    property Alignment: TAlignment read FAlignment write SetAlignment;
    property BGColor : TIWColor read GetBGColor write SetBGColor;
    {$IFDEF CLR}
    property WebFont;
    {$ELSE}
    property Font;
    {$ENDIF}
    property NoWrap: Boolean read FNoWrap write FNoWrap;
    property ConvertSpaces: Boolean read FConvertSpaces write FConvertSpaces;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWLabel.bmp}
  TIWLabel = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWLabel), 'TIWLabel.bmp')]
  {$ENDIF}
  TIWLabel = class(TIWCustomLabel)
  published
    property AutoSize;
    property FriendlyName;

    {$IFDEF VSNET}
    property Text;
    {$ELSE}
    property Caption;
    {$ENDIF}
    property RawText;
  end;

implementation

uses
  {$IFDEF VSNET}
  IWNetBaseControl,
  {$ENDIF}
  SysUtils;



{$IFDEF VSNET}
function TIWCustomLabel.getText: string;
begin
  Result := Caption;
end;

procedure TIWCustomLabel.setText(AValue: string); 
begin
  Caption := AValue;
  TIWNETBaseControl(Self).Invalidate;
end;
{$ENDIF}

function TIWCustomLabel.get_HasTabOrder: boolean;
begin
  result:=false;
end;

function TIWCustomLabel.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LStyle: string;
begin
  LStyle := 'style=';
  Result := TIWHTMLTag.CreateTag('SPAN'); try
    if not FRawText then begin
      if NoWrap then begin
        Result.Contents.AddText('<NOBR>' + TextToHTML(Caption, True, FConvertSpaces) + '</NOBR>');
      end else begin
        Result.Contents.AddText(TextToHTML(Caption, True, FConvertSpaces));
      end;
    end else begin
      if NoWrap then begin
        Result.Contents.AddText('<NOBR>' + Caption + '</NOBR>');
      end else begin
        Result.Contents.AddText(Caption);
      end;
    end;
    case Alignment of
      taLeftJustify: LStyle := LStyle + 'text-align:left;';
      taCenter: LStyle := LStyle + 'text-align:center;';
      taRightJustify: LStyle := LStyle + 'text-align:right;';
    end;
    if toTColor(WebColor) <> clNone then  begin
      LStyle := LStyle + 'background-color:' + ColorToRGBString(WebColor) +';';
    end;
    if LStyle <> 'style=' then begin
      Result.Add(LStyle);
    end;
  except
    FreeAndNil(Result);
    raise;
  end;
end;

procedure TIWCustomLabel.InitControl;
begin
  inherited;
  Height := 21;
  Width := 121;
  AutoSize := TRUE;
  FRawText := FALSE;
  FAlignment := taLeftJustify;
  WebColor := fromTColor(clNone);
end;

procedure TIWCustomLabel.SetAutoSize(Value: Boolean);
begin
  inherited SetAutoSize(Value);
  RenderSize := not Value;
end;

procedure TIWCustomLabel.SetAlignment(const Value: TAlignment);
begin
  if FAlignment <> Value then begin
    FAlignment := Value;
    Invalidate;
  end;
end;

procedure TIWCustomLabel.SetRawText(Value: Boolean);
begin
  FRawText := Value;
end;

procedure TIWCustomLabel.SetBGColor(Value: TIWColor);
begin
  WebColor := Value;
end;

function TIWCustomLabel.GetBGColor : TIWColor;
begin
  Result := WebColor;
end;

function TIWCustomLabel.RenderStyle(AComponentContext: TIWBaseHTMLComponentContext): string;
var
  LAutoSizeOld : boolean;
  LRenderSizeOld : boolean;
begin
  LAutoSizeOld := AutoSize;
  LRenderSizeOld := RenderSize;

  // for label sizing should be displayed according to (RenderSize and not AutoSize)
  // IWControl algorithm works according to (RenderSize or not AutoSize)

  if RenderSize = AutoSize then
    begin
      RenderSize := false;
      AutoSize := true;
    end;

  Result := inherited RenderStyle(AComponentContext);

  AutoSize := LAutoSizeOld;
  RenderSize := LRenderSizeOld;
end;


end.

